import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'AddUser'
 * created in the main() method.
 */
public class AddUser extends Form { 
	private UserPass m_userpass;
	private boolean m_admaccess;
	private String m_extension;
	private String m_message;
	
	public AddUser()
	{
		super();

		// Required for Visual J++ Form Designer support
		initForm();		

		// TODO: Add any constructor code after initForm call
	}

	/**
	 * AddUser overrides dispose so it can clean up the
	 * component list.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	public UserPass getUserPass() {
		return m_userpass;
	}
	
	public boolean getAdmAccess() {
		return m_admaccess;
	}
	
	public String getExtension() 
	{
		return m_extension;
	}
	
	public String getMessage() 
	{
		return m_message;
	}
	
	private void button2_click(Object source, Event e) {
		this.setDialogResult(DialogResult.CANCEL);
	}

	private void button1_click(Object source, Event e) {
		m_userpass = new UserPass(edit1.getText(), edit2.getText());
		m_admaccess = checkBox1.getChecked();
		if(checkBox2.getChecked()) m_extension = edit3.getText();
		else m_extension = null;
		m_message = edit4.getText();
		this.setDialogResult(DialogResult.OK);
	}


	private void checkBox2_click(Object source, Event e)
	{
		if(checkBox2.getChecked()) 
		{
			edit3.setEnabled(true);
			edit3.setBackColor(Color.WINDOW);
		}
		else 
		{
			edit3.setEnabled(false);
			edit3.setBackColor(Color.INACTIVEBORDER);
		}
	}

	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	Label label2 = new Label();
	Label label1 = new Label();
	Edit edit2 = new Edit();
	Edit edit1 = new Edit();
	Button button1 = new Button();
	Button button2 = new Button();
	CheckBox checkBox1 = new CheckBox();
	Edit edit3 = new Edit();
	CheckBox checkBox2 = new CheckBox();
	Label label3 = new Label();
	Edit edit4 = new Edit();

	private void initForm()
	{
		// NOTE:  This form is storing resource information in an
		// external file.  Do not modify the string parameter to any
		// resources.getObject() function call. For example, do not
		// modify "foo1_location" in the following line of code
		// even if the name of the Foo object changes: 
		//   foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "AddUser");
		label2.setLocation(new Point(16, 48));
		label2.setSize(new Point(80, 16));
		label2.setTabIndex(10);
		label2.setTabStop(false);
		label2.setText("Password");

		label1.setLocation(new Point(16, 18));
		label1.setSize(new Point(80, 16));
		label1.setTabIndex(8);
		label1.setTabStop(false);
		label1.setText("Username");

		edit2.setLocation(new Point(112, 46));
		edit2.setSize(new Point(184, 20));
		edit2.setTabIndex(1);
		edit2.setText("");
		edit2.setAcceptsReturn(false);

		edit1.setLocation(new Point(112, 16));
		edit1.setSize(new Point(184, 20));
		edit1.setTabIndex(0);
		edit1.setText("");
		edit1.setAcceptsReturn(false);

		button1.setLocation(new Point(128, 156));
		button1.setSize(new Point(75, 23));
		button1.setTabIndex(6);
		button1.setText("OK");
		button1.addOnClick(new EventHandler(this.button1_click));

		button2.setLocation(new Point(216, 156));
		button2.setSize(new Point(75, 23));
		button2.setTabIndex(7);
		button2.setText("Cancel");
		button2.addOnClick(new EventHandler(this.button2_click));

		this.setText("AddUser");
		this.setAcceptButton(button1);
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setCancelButton(button2);
		this.setClientSize(new Point(306, 198));
		this.setControlBox(false);
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.setKeyPreview(true);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		checkBox1.setLocation(new Point(16, 156));
		checkBox1.setSize(new Point(104, 16));
		checkBox1.setTabIndex(5);
		checkBox1.setText("Administrator");

		edit3.setBackColor(Color.INACTIVEBORDER);
		edit3.setEnabled(false);
		edit3.setLocation(new Point(112, 80));
		edit3.setSize(new Point(184, 20));
		edit3.setTabIndex(3);
		edit3.setText("");
		edit3.setAcceptsReturn(false);

		checkBox2.setLocation(new Point(16, 80));
		checkBox2.setSize(new Point(88, 20));
		checkBox2.setTabIndex(2);
		checkBox2.setText("Set Extension");
		checkBox2.addOnClick(new EventHandler(this.checkBox2_click));

		label3.setLocation(new Point(16, 114));
		label3.setSize(new Point(80, 16));
		label3.setTabIndex(9);
		label3.setTabStop(false);
		label3.setText("Message");

		edit4.setLocation(new Point(112, 112));
		edit4.setSize(new Point(184, 20));
		edit4.setTabIndex(4);
		edit4.setText("");
		edit4.setAcceptsReturn(false);

		this.setNewControls(new Control[] {
							edit4, 
							label3, 
							checkBox2, 
							edit3, 
							edit1, 
							checkBox1, 
							button2, 
							button1, 
							label2, 
							edit2, 
							label1});
	}

	/**
	 * The main entry point for the application. 
	 *
	 * @param args Array of parameters passed to the application
	 * via the command line.
	 */
	public static void main(String args[])
	{
		Application.run(new AddUser());
	}
}
